<?php

namespace App\Traits;

use App\Models\Admin\Admin;
use App\Models\History\History;
use App\Models\User\User;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Str;

trait HistoryLogger
{
    use HistoryCreator;

    public static function bootHistoryLogger()
    {
        static::created(function ($model) {
            $model->createHistory(get_class($model), $model->id , 'added');
        });

        static::updated(function ($model) {
            $model->createHistory(get_class($model), $model->id , 'edited');
        });

        static::deleted(function ($model) {
            $model->createHistory(get_class($model), $model->id , 'deleted');
        });
    }


    
}
