<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RfqBid extends Model
{
    use HasFactory;

    protected $fillable = ['rfq_id', 'vendor_id', 'price' , 'is_approved','user_id'];

    /**
     * Get the RFQ associated with this bid.
     */
    public function rfq(): BelongsTo
    {
        return $this->belongsTo(RFQ::class);
    }

    /**
     * Get the vendor (user) associated with this bid.
     */
    public function vendor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'vendor_id');
    }
}
