<?php

namespace App\Models;

use App\Traits\GetAttribute;
use App\Traits\SearchableRelations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RFQ extends Model
{
    use HasFactory , SearchableRelations , GetAttribute;

    protected $fillable = [
        'product_id',
        'spec_id',
        'branch_id',
        'price',
        'qty',
        'status',
        'vendor_id',
        'user_id',
        'is_approved',
        'payment_method',
        'order_type',
        'bank_account_id',
        'card_id'
    ];

    /**
     * Get the product associated with the RFQ.
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * Get the spec associated with the RFQ.
     */

     public function __construct(array $attributes = [])
     {
         parent::__construct($attributes);
         $this->multiple_attachment = true;
         $this->multiple_attachment_usage = ['default', 'bdf-file'];
     }


     public function getImageAttribute()
     {
         return $this->attachmentRelation()->first();
     }


    /**
     * Get the branch associated with the RFQ.
     */
    public function branch()
    {
        return $this->belongsTo(Branch::class , 'branch_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function vendor()
    {
        return $this->belongsTo(User::class,'vendor_id');
    }

    public function rfqSpecs()
    {
        return $this->hasMany(RfqsSpecs::class, 'rfq_id');
    }

    /**
     * Relation to Spec model through RFQSpec.
     */
    public function specs()
    {
        return $this->belongsToMany(Spec::class, 'rfqs_specs', 'rfq_id', 'spec_id');
    }

    public function bids(): HasMany
    {
        return $this->hasMany(RfqBid::class, 'rfq_id'); // Explicitly set the foreign key.
    }


    public function rfqItems()
    {
        return $this->hasMany(RfqItem::class , 'rfq_id');
    }

    public function isChecked()
    {
        return $this->bids()
            ->where('vendor_id', auth()->user()->id)
            ->exists(); // 'rfq_id' is handled by the relationship.
    }


}
