<?php

namespace App\Http\Resources\Dentist;

use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CartItemsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->product->id,
            'name' => $this->product->name,
            'description' => $this->product->description,
            'image' => MediaResource::make($this->product->image),
            'price' => $this->product->price,
            'specs' => $this->product->specs,
            'qty' => $this->quantity,
            'main_category' => [
                'id' => $this->product->mainCategory->id,
                'name' => $this->product->mainCategory->name,

            ],
            'sub_category' => [
                'id' => $this->product->subCategory?->id,
                'name' => $this->product->subCategory?->name,

            ],
            'is_fave' => $this->product->IsFav,
            'is_in_cart' => $this->product->is_in_cart

            // 'created_at' => $this->product->created_at->toDateTimeString(),
            // 'updated_at' => $this->product->updated_at->toDateTimeString(),
        ];
    }

    /**
     * Get the full category hierarchy starting from the main category to the subcategory.
     */
    private function getCategoryHierarchy()
    {
        $categories = [];

        // If sub_category_id is null, return only the main category
        if (is_null($this->product->sub_category_id)) {
            if ($this->product->mainCategory) {
                $categories[] = $this->product->mainCategory;
            }
        } else {
            // Start with the subcategory (the lowest child)
            $currentCategory = $this->product->subCategory;

            // Traverse up to the top parent
            while ($currentCategory) {
                $categories[] = $currentCategory; // Add the current category to the list
                $currentCategory = $currentCategory->parent; // Move to the parent
            }

            // Reverse the categories array to have the highest parent first
            $categories = array_reverse($categories);
        }

        return $categories;
    }

}
