<?php

namespace App\Traits;

use Illuminate\Support\Facades\Auth;
use App\Notifications\PushNotification;
use Illuminate\Support\Facades\Notification;

trait Notificationable
{
    public function sendNotification($user, $title, $message)
    {
        $notificationData = [
            'title' => $title,
            'message' => $message,
            'user_id' => $user->id,
        ];

        // Store in database
        $user->notify(new PushNotification($notificationData));

        // Send via Pusher
        Notification::send($user, new \App\Notifications\PushNotification($notificationData));
    }
}
